/*
 * Decompiled with CFR 0.152.
 */
package generate_package;

import generate_package.GeneratePackage;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.activation.MimetypesFileTypeMap;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WindowPane
extends JPanel
implements ActionListener {
    private JFrame myFrame;
    private JPanel myPanel;
    private Container c;
    private JTextField filetext;
    private JTextField outputtext;
    private JTextField acronym;
    private JButton button1;
    private JButton button2;
    private JButton submit_button;
    private String filepath = "";
    private String name = "";
    private String outputpath = "";
    private String stringacronym = "";
    private Image logo = null;
    private int width;
    private String currenttext = "";
    private Thread g = null;
    private Thread f = null;
    private GeneratePackage generator;

    public WindowPane(JFrame myFrame) {
        try {
            this.logo = ImageIO.read(this.getClass().getResource("/images/logo.png"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.myFrame = myFrame;
        this.myPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(WindowPane.this.logo, 40, 160, null);
                if (WindowPane.this.submit_button.getText().equals("Cancel")) {
                    g.drawString(WindowPane.this.currenttext, 120, 140);
                    g.drawRect(120, 140, 360, 10);
                    g.setColor(Color.WHITE);
                    g.fillRect(120, 140, 360, 10);
                    g.drawRect(120, 140, WindowPane.this.width, 10);
                    g.setColor(new Color(23, 89, 133));
                    g.fillRect(120, 140, WindowPane.this.width, 10);
                }
            }
        };
        this.myPanel.setSize(myFrame.getSize());
        this.c = myFrame.getContentPane();
        JLabel instructions1 = new JLabel("Choose a folder of game camera images:  ");
        this.myPanel.add(instructions1);
        this.filetext = new JTextField(20);
        this.myPanel.add(this.filetext);
        this.button1 = new JButton("Browse");
        this.button1.setBackground(new Color(23, 89, 133));
        this.button1.setForeground(Color.white);
        this.button1.addActionListener(this);
        this.myPanel.add(this.button1);
        JLabel instructions2 = new JLabel("Choose a folder to store the output files in:");
        this.myPanel.add(instructions2);
        this.outputtext = new JTextField(20);
        this.myPanel.add(this.outputtext);
        this.button2 = new JButton("Browse");
        this.button2.setBackground(new Color(23, 89, 133));
        this.button2.setForeground(Color.white);
        this.button2.addActionListener(this);
        this.myPanel.add(this.button2);
        JLabel instructions3 = new JLabel("Enter the acronym of the associated research project:");
        this.myPanel.add(instructions3);
        this.acronym = new JTextField(20);
        this.myPanel.add(this.acronym);
        this.submit_button = new JButton("Submit");
        this.submit_button.setBackground(new Color(23, 89, 133));
        this.submit_button.setForeground(Color.white);
        this.submit_button.addActionListener(this);
        this.myPanel.add(this.submit_button);
        this.myPanel.repaint();
        this.myPanel.setVisible(true);
        this.c.add(this.myPanel);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(500, 600);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        final JFrame frame = new JFrame();
        if (event.getSource().equals(this.button1) && this.button1.isEnabled()) {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            fc.showOpenDialog(fc);
            try {
                this.filepath = fc.getCurrentDirectory().toString();
                this.name = fc.getSelectedFile().getName();
                this.filetext.setText(String.valueOf(this.filepath) + "\\" + this.name);
                File folder = new File(String.valueOf(this.filepath) + "\\" + this.name);
                File[] listOfFiles = folder.listFiles();
                if (listOfFiles.length == 0) {
                    JOptionPane.showMessageDialog(frame, "The specified folder is empty.");
                }
                int count = 0;
                int i = 0;
                while (i < listOfFiles.length) {
                    String mimetype = new MimetypesFileTypeMap().getContentType(listOfFiles[i]);
                    String type = mimetype.split("/")[0];
                    if (type.equals("image")) {
                        ++count;
                    }
                    ++i;
                }
                if (count == 0) {
                    JOptionPane.showMessageDialog(frame, "The specified folder has no images.");
                }
            }
            catch (NullPointerException e) {
                frame.dispatchEvent(new WindowEvent(this.myFrame, 201));
            }
        } else if (event.getSource().equals(this.button2) && this.button2.isEnabled()) {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            fc.showOpenDialog(fc);
            this.outputpath = "";
            try {
                this.outputpath = String.valueOf(fc.getCurrentDirectory().toString()) + "\\" + fc.getSelectedFile().getName();
                this.outputtext.setText(this.outputpath);
            }
            catch (NullPointerException e) {
                frame.dispatchEvent(new WindowEvent(this.myFrame, 201));
            }
        } else if (event.getSource().equals(this.submit_button)) {
            if (this.submit_button.getText().equals("Submit")) {
                this.submit_button.setText("Cancel");
                this.button1.setEnabled(false);
                this.button2.setEnabled(false);
                this.stringacronym = this.acronym.getText();
                if (this.filepath.isEmpty()) {
                    JOptionPane.showMessageDialog(frame, "A folder of images must be specified.");
                    this.submit_button.setText("Submit");
                    this.button1.setEnabled(true);
                    this.button2.setEnabled(true);
                    return;
                }
                if (this.outputpath.isEmpty()) {
                    JOptionPane.showMessageDialog(frame, "An output folder must be specified.");
                    this.submit_button.setText("Submit");
                    this.button1.setEnabled(true);
                    this.button2.setEnabled(true);
                    return;
                }
                if (this.stringacronym.isEmpty()) {
                    JOptionPane.showMessageDialog(frame, "An acronym must be specified.");
                    this.submit_button.setText("Submit");
                    this.button1.setEnabled(true);
                    this.button2.setEnabled(true);
                    return;
                }
                this.generator = new GeneratePackage(this.name, this.stringacronym, this.filepath, this.outputpath);
                this.g = new Thread(this.generator);
                this.f = new Thread(){

                    @Override
                    public void run() {
                        WindowPane.this.currenttext = "Generating zip file...";
                        WindowPane.this.myPanel.repaint();
                        while (!this.isInterrupted()) {
                            WindowPane.this.width = WindowPane.this.generator.getStatus();
                            WindowPane.this.myPanel.repaint();
                            if (WindowPane.this.generator.getStatus() == 120) {
                                WindowPane.this.currenttext = "Generating data...";
                            } else if (WindowPane.this.generator.getStatus() == 240) {
                                WindowPane.this.currenttext = "Writing YAML file...";
                            } else if (WindowPane.this.generator.getStatus() == 360) break;
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                        WindowPane.this.width = 360;
                        WindowPane.this.currenttext = "Complete.";
                        WindowPane.this.myPanel.repaint();
                        JOptionPane.showMessageDialog(frame, "Your files have been successfully created.");
                        WindowPane.this.button1.setEnabled(true);
                        WindowPane.this.button2.setEnabled(true);
                        WindowPane.this.submit_button.setText("Submit");
                        WindowPane.this.myPanel.repaint();
                    }
                };
                this.g.start();
                this.f.start();
            } else {
                Object[] options = new Object[]{"Yes, I'm sure", "No, do not cancel"};
                int n = JOptionPane.showOptionDialog(frame, "Are you sure you would like to cancel? All progress will be lost.", "Cancel?", 2, 3, null, options, options[1]);
                if (n == 0) {
                    this.generator.stop();
                    this.f.interrupt();
                    this.width = 0;
                    this.button1.setEnabled(true);
                    this.button2.setEnabled(true);
                    this.submit_button.setText("Submit");
                    this.myPanel.repaint();
                    return;
                }
            }
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setSize(600, 450);
        WindowPane mypane = new WindowPane(frame);
        mypane.repaint();
        frame.add(mypane);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

