/*
 * Decompiled with CFR 0.152.
 */
package generate_package;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.MimetypesFileTypeMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class GeneratePackage
implements Runnable {
    private LinkedHashMap<String, Object> collection_def;
    private LinkedHashMap<String, ArrayList<LinkedHashMap<String, Object>>> data_dict;
    private ArrayList<LinkedHashMap<String, String>> resources;
    private String name;
    private String filepath;
    private String outputpath;
    private String acronym;
    private int status = 0;
    private boolean interrupted = false;

    public GeneratePackage(String name, String acronym, String filepath, String outputpath) {
        this.acronym = acronym;
        this.name = name;
        this.filepath = filepath;
        this.outputpath = outputpath;
        this.collection_def = new LinkedHashMap();
        this.collection_def.put("name", name);
        this.collection_def.put("project_name", "'" + acronym + "'");
        this.collection_def.put("resources_dir", name);
        this.collection_def.put("deployments", new ArrayList());
        this.data_dict = new LinkedHashMap();
        ArrayList<LinkedHashMap<String, Object>> collection_obj = new ArrayList<LinkedHashMap<String, Object>>();
        collection_obj.add(this.collection_def);
        this.data_dict.put("collections", collection_obj);
    }

    public void generateData(String filepath, String filename) throws FileNotFoundException {
        JFrame frame = new JFrame();
        this.resources = new ArrayList();
        File folder = new File(String.valueOf(filepath) + "/" + filename);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles == null) {
            JOptionPane.showMessageDialog(frame, "The specified folder could not be found.");
            System.exit(1);
        }
        int i = 0;
        while (i < listOfFiles.length) {
            Metadata metadata = null;
            try {
                metadata = ImageMetadataReader.readMetadata(listOfFiles[i]);
            }
            catch (ImageProcessingException | IOException e) {
                JOptionPane.showMessageDialog(frame, "The specified files were of an incompatible format.");
                System.exit(1);
            }
            ExifSubIFDDirectory directory = metadata.getFirstDirectoryOfType(ExifSubIFDDirectory.class);
            if (directory != null) {
                LinkedHashMap<String, String> resource_def = new LinkedHashMap<String, String>();
                resource_def.put("name", listOfFiles[i].getName().substring(0, listOfFiles[i].getName().indexOf(".")));
                resource_def.put("file", listOfFiles[i].getName());
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                resource_def.put("date_recorded", String.valueOf(df.format(directory.getDate(36867))) + "+00:00");
                this.resources.add(resource_def);
                this.status += 120 / listOfFiles.length;
                if (this.interrupted) {
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            ++i;
        }
        this.collection_def.put("resources", this.resources);
        this.status = 240;
    }

    public void generateZip(String filepath, String filename, String outputpath) throws IOException {
        JFrame frame = new JFrame();
        File f = new File(String.valueOf(outputpath) + "/" + filename + ".zip");
        byte[] buf = new byte[1024];
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new FileOutputStream(f));
        }
        catch (FileNotFoundException e1) {
            JOptionPane.showMessageDialog(frame, "The specified folder could not be found.");
            System.exit(1);
        }
        File folder = new File(String.valueOf(filepath) + "/" + filename);
        File[] listOfFiles = folder.listFiles();
        int i = 0;
        while (i < listOfFiles.length) {
            int len;
            FileInputStream in = null;
            try {
                in = new FileInputStream(listOfFiles[i].toString());
            }
            catch (FileNotFoundException e1) {
                JOptionPane.showMessageDialog(frame, "The specified folder could not be found.");
                System.exit(1);
            }
            String mimetype = new MimetypesFileTypeMap().getContentType(listOfFiles[i]);
            String type = mimetype.split("/")[0];
            if (!type.equals("image")) {
                ++i;
            }
            ZipEntry e = new ZipEntry(String.valueOf(filename) + "/" + listOfFiles[i].getName());
            out.putNextEntry(e);
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            in.close();
            this.status += 120 / listOfFiles.length;
            if (this.interrupted) {
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                return;
            }
            ++i;
        }
        out.close();
        this.status = 120;
    }

    public String toString() {
        Object[] data_keys = this.data_dict.keySet().toArray();
        String returnString = data_keys[0] + ":\n- ";
        Object[] collection_keys = this.collection_def.keySet().toArray();
        int i = 0;
        while (i < collection_keys.length - 1) {
            returnString = String.valueOf(returnString) + (i != 0 ? "  " : "") + collection_keys[i] + ": " + this.collection_def.get(collection_keys[i]) + "\n";
            this.status += 60 / collection_keys.length;
            if (this.interrupted) {
                return "";
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return "";
            }
            ++i;
        }
        returnString = String.valueOf(returnString) + "  " + collection_keys[i] + ":\n";
        int j = 0;
        while (j < this.resources.size()) {
            Object[] resources_def = this.resources.get(j).keySet().toArray();
            returnString = String.valueOf(returnString) + "  - {";
            int x = 0;
            while (x < resources_def.length) {
                returnString = String.valueOf(returnString) + resources_def[x] + ": " + (x == resources_def.length - 1 ? "'" : "") + this.resources.get(j).get(resources_def[x]) + (x == resources_def.length - 1 ? "'" : "");
                if (x != resources_def.length - 1) {
                    returnString = String.valueOf(returnString) + ", ";
                }
                ++x;
            }
            returnString = String.valueOf(returnString) + "}\n";
            this.status = j == this.resources.size() - 1 ? 360 : (this.status += 60 / this.resources.size());
            if (this.interrupted) {
                return "";
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return "";
            }
            ++j;
        }
        this.status = 360;
        return returnString;
    }

    public int getStatus() {
        return this.status;
    }

    public void stop() {
        this.interrupted = true;
    }

    @Override
    public void run() {
        try {
            this.generateZip(this.filepath, this.name, this.outputpath);
            if (this.interrupted) {
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return;
            }
            this.generateData(this.filepath, this.name);
            if (this.interrupted) {
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return;
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(this.outputpath) + "/" + this.name + ".yaml"));
            writer.write(this.toString());
            writer.close();
            if (this.interrupted) {
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        catch (IOException e) {
            return;
        }
    }
}

